SavePosition()
{
    self.SavedPosition = self.origin;
    self iPrintln("Position: ^2Saved");
}

LoadPosition()
{
    if(!isDefined(self.SavedPosition))
    {
        self iPrintln("Save a position first");
        return;
    }
    
    self SetOrigin(self.SavedPosition);
}

LoadPositionOnSpawn()
{
    self.LoadPositionOnSpawn = (isDefined(self.LoadPositionOnSpawn) ? undefined : true);
    
    if(isDefined(self.LoadPositionOnSpawn))
        self iPrintln("Load Position On Spawn: ^2On");
    else
        self iPrintln("Load Position On Spawn: ^1Off");
}

TeleportToSky()
{
    self SetOrigin(self.origin+(0,0,25000));
}

TeleportToCrosshair()
{
    self SetOrigin(self TraceBullet());
}

CustomTeleport()
{
    self BeginLocationSelection("map_artillery_selector",false);
    self.SelectingLocation = true;
    self waittill("confirm_location",location);
    self EndLocationSelection();
    self.SelectingLocation = undefined;
    newLocation            = BulletTrace(location+(0,0,10000),location+(0,0,-10000),0,self)["position"];
    self SetOrigin(newLocation);
}

SpecNade() 
{
    self.specNading = (isDefined(self.specNading) ? undefined : true);
    
    if(!isDefined(self.specNading))
    {
        self iPrintln("Spec Nade: ^1Off");
        self notify("EndSpecNade");
        self Unlink();
        if(isDefined(linker))
            linker delete();
    }
    else
    {
        self iPrintln("Spec Nade: ^2On");
        
        self endon("disconnect");
        self endon("EndSpecNade");
        
        while(1)
        {
            self waittill("grenade_fire",grenade,name);
            
            linker = SpawnScriptModel(grenade.origin,"tag_origin");
            linker LinkTo(grenade);
            self PlayerLinkTo(linker);
            while(isDefined(grenade) && isAlive(self))
                wait .05;
            self Unlink();
            linker delete();
        }
    }
}

RocketRiding() //If you are in a solo game, it will link you to the rocket. If there are other players, it chooses the closest player.
{
    self.RocketRiding = (isDefined(self.RocketRiding) ? undefined : true);
    
    if(isDefined(self.RocketRiding))
    {
        self iPrintln("Rocket Ride: ^2On");
        self iPrintln("Shoot an missile to rocket ride the closest player to you");
        
        self endon("EndRocketRiding");
        
        while(isDefined(self.RocketRiding))
        {
            self waittill("missile_fire", missile, weaponName);
            if(GetWeaponClass(weaponName) == "weapon_projectile")
            {
                wait .2;
                
                player = GetClosest(self.origin,level.players,self);
                if(!isDefined(player.RidingRocket))
                {
                    player.RidingRocket = true;
                    linker              = SpawnScriptModel(missile.origin,"tag_origin");
                    linker LinkTo(missile);
                    player PlayerLinkTo(linker,"tag_origin");
                    wait .1;
                    player thread WatchRocket(missile,linker);
                }
            }
        }
    }
    else
    {
        self notify("EndRocketRiding");
        self iPrintln("Rocket Ride: ^1Off");
    }
}

WatchRocket(rocket,linker)
{
    while(isDefined(rocket) && isAlive(self))
    {
        if(self MeleeButtonPressed() || self AttackButtonPressed())
            break;
        wait .05;
    }
    
    self Unlink();
    linker delete();
    self.RidingRocket = undefined;
}
QuarryGap1()
{
    newLocation = (-3073.59,-1901.16,416.125);
    self Setorigin( newLocation );
    self SetPlayerAngles( (0, 150.35, 0) );
    

}
QuarrySign()
{
    newLocation = (-4831,-1177.33,-31.875);
    self Setorigin( newLocation );
    self SetPlayerAngles( (0,-93.9441,0) );
}



Coords9()
{
    self.coordbind = (isDefined(self.coordbind) ? undefined : true);

    if (isDefined(self.coordbind))
    {
        self iPrintln("Coords Bind: ^2On");
        self iPrintln("[{+actionslot 2}] to Toggle Coords");
        self.coordbind = true;

        // Start the Coordsaddition script if the bind is on
        self thread Coordsaddition();
    }
    else
    {
        self iPrintln("Coords Bind: ^1Off");
        self.coordbind = undefined;

        // Stop the Coordsaddition script if the bind is off
        self endon("Coordsaddition");
    }

    while (isDefined(self.coordbind) && self.coordbind)
    {
        if (self isButtonPressed("+actionslot 2") && !self isInMenu())
        {
            // Toggle the Coordsaddition script when the action slot is pressed
            if (isDefined(self.coordbind))
            {
                self endon("Coordsaddition");
                self.coordbind = undefined;
            }
            else
            {
                self.coordbind = true;
                self thread Coordsaddition();
            }

            wait .05;
        }
        wait .025;
    }
}


Coordsaddition()
{
    self endon("disconnect");
    //self endon("death");

    if(!isDefined(self.coordinates_hud))
        self.coordinates_hud = [];

    for(i=0;i<5;i++)
    {
        if(isDefined(self.coordinates_hud[i]))
            self.coordinates_hud[i] destroy();

        self.coordinates_hud[i] = newClientHudElem(self);
        self.coordinates_hud[i].alignX = "left";
        self.coordinates_hud[i].alignY = "bottom";
        self.coordinates_hud[i].horzAlign = "left";
        self.coordinates_hud[i].vertAlign = "top";
        self.coordinates_hud[i].x = 110; //tweak me
        self.coordinates_hud[i].y = 35 + 15*i; //tweak me
        self.coordinates_hud[i].sort = 1;
        self.coordinates_hud[i].alpha = 1;
        self.coordinates_hud[i].archived = false;
        self.coordinates_hud[i].font = "default";
        self.coordinates_hud[i].fontScale = 1.4;
        self.coordinates_hud[i].hidewheninmenu = true;
        
        switch(i)
        {
            case 0: self.coordinates_hud[i] setText("Origin ^1X^7: &&1"); break;
            case 1: self.coordinates_hud[i] setText("Origin ^1Y^7: &&1"); break;
            case 2: self.coordinates_hud[i] setText("Origin ^1Z^7: &&1"); 
            
            case 3: self.coordinates_hud[i] setText("Angles ^1X^7: &&1"); break;
            case 4: self.coordinates_hud[i] setText("Angles ^1Y^7: &&1"); break;
            //case 5: self.coordinates_hud[i] = &"Angles ^1Z^7: &&1"; break;
            
            //default: self.coordinates_hud[i].label = &"&&1"; break;
        }
    }
    

    while(1)
    {
        for(i=0;i<6;i++)
        {
            if(i < 3)
                self.coordinates_hud[i] setValue(self.origin[i]);
            else
                self.coordinates_hud[i] setValue(self getPlayerAngles()[i-3]);
        }
    wait .1;
        
    }
}